<?php
// Set the recipient email address
$to = 'carolyn.nelson@davidsonwealthteam.com';

// Check if form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get form type
    $form_type = isset($_POST['form_type']) ? $_POST['form_type'] : '';
    
    // Initialize variables
    $subject = '';
    $message = '';
    $headers = '';
    $success = false;
    
    // Process different form types
    if ($form_type === 'agreement') {
        // Process agreement form
        $full_name = isset($_POST['full_name']) ? htmlspecialchars($_POST['full_name']) : '';
        $email = isset($_POST['email']) ? htmlspecialchars($_POST['email']) : '';
        $date = isset($_POST['date']) ? htmlspecialchars($_POST['date']) : '';
        $agreement_status = isset($_POST['agreement_status']) ? htmlspecialchars($_POST['agreement_status']) : 'false';
        
        // Prepare email content
        $subject = 'New Investment Advisory Agreement Submission - ' . $full_name;
        $message = "
        <html>
        <head>
            <title>Investment Advisory Agreement Submission</title>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; }
                .header { background-color: #f8f9fa; padding: 20px; text-align: center; }
                .content { padding: 20px; }
                .details { margin-bottom: 20px; }
                .details dt { font-weight: bold; margin-top: 10px; }
            </style>
        </head>
        <body>
            <div class='header'>
                <h2>Investment Advisory Agreement Submission</h2>
            </div>
            <div class='content'>
                <p>A new client has submitted the Investment Advisory Agreement:</p>
                
                <div class='details'>
                    <dl>
                        <dt>Client Name:</dt>
                        <dd>$full_name</dd>
                        
                        <dt>Email Address:</dt>
                        <dd>$email</dd>
                        
                        <dt>Submission Date:</dt>
                        <dd>$date</dd>
                        
                        <dt>Agreement Status:</dt>
                        <dd>" . ($agreement_status === 'true' ? 'Agreed' : 'Not Agreed') . "</dd>
                    </dl>
                </div>
                
                <p>This is an automated notification. Please respond to the client directly.</p>
            </div>
        </body>
        </html>
        ";
        
        // Set headers for HTML email
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";
        $headers .= "From: $email\r\n";
        $headers .= "Reply-To: $email\r\n";
        
        // Send email
        $success = mail($to, $subject, $message, $headers);
        
        // Redirect after submission
        if ($success) {
            header('Location: https://www.davidsonwealthteam.com/setup_1_erfan_m.html?success=1');
        } else {
            header('Location: index.html?error=1');
        }
        exit();
        
    } elseif ($form_type === 'question') {
        // Process question form
        $name = isset($_POST['name']) ? htmlspecialchars($_POST['name']) : '';
        $email = isset($_POST['email']) ? htmlspecialchars($_POST['email']) : '';
        $question = isset($_POST['question']) ? htmlspecialchars($_POST['question']) : '';
        
        // Prepare email content
        $subject = 'New Question from ' . $name;
        $message = "
        <html>
        <head>
            <title>New Client Question</title>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; }
                .header { background-color: #f8f9fa; padding: 20px; text-align: center; }
                .content { padding: 20px; }
                .question { background-color: #f1f1f1; padding: 15px; border-left: 4px solid #3498db; margin: 15px 0; }
            </style>
        </head>
        <body>
            <div class='header'>
                <h2>New Client Question</h2>
            </div>
            <div class='content'>
                <p>You have received a new question from a client:</p>
                
                <div class='details'>
                    <p><strong>From:</strong> $name</p>
                    <p><strong>Email:</strong> $email</p>
                </div>
                
                <div class='question'>
                    <h3>Question:</h3>
                    <p>$question</p>
                </div>
                
                <p>Please respond to the client at your earliest convenience.</p>
            </div>
        </body>
        </html>
        ";
        
        // Set headers for HTML email
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";
        $headers .= "From: $email\r\n";
        $headers .= "Reply-To: $email\r\n";
        
        // Send email
        $success = mail($to, $subject, $message, $headers);
        
        // Redirect after submission
        if ($success) {
            header('Location: index.html?question_success=1');
        } else {
            header('Location: index.html?question_error=1');
        }
        exit();
    }
}

// If form type is not recognized or not submitted properly, redirect back
header('Location: index.html');
exit();
?>