<?php
// Set the content type to HTML
header('Content-Type: text/html; charset=UTF-8');

// Define variables and initialize with empty values
$errors = [];
$success = false;

// Process form data when form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate and sanitize personal information
    $name = trim($_POST["name"]);
    $email = filter_var(trim($_POST["email"]), FILTER_SANITIZE_EMAIL);
    $address = trim($_POST["address"]);
    $city = trim($_POST["city"]);
    $zip = trim($_POST["zip"]);
    $phone = trim($_POST["phone"]);
    $occupation = trim($_POST["occupation"]);
    $broker_info = trim($_POST["broker_info"]);
    
    // Financial Strength
    $income = isset($_POST["income"]) ? $_POST["income"] : '';
    $net_worth = isset($_POST["net_worth"]) ? $_POST["net_worth"] : '';
    $fund_source = isset($_POST["fund_source"]) ? $_POST["fund_source"] : '';
    $initial_investment = isset($_POST["initial_investment"]) ? $_POST["initial_investment"] : '';
    
    // Time Horizon
    $age = isset($_POST["age"]) ? $_POST["age"] : '';
    $primary_goal = isset($_POST["primary_goal"]) ? $_POST["primary_goal"] : '';
    $time_frame = isset($_POST["time_frame"]) ? $_POST["time_frame"] : '';
    $retirement_years = isset($_POST["retirement_years"]) ? $_POST["retirement_years"] : '';
    
    // Financial Goals
    $financial_goal = isset($_POST["financial_goal"]) ? $_POST["financial_goal"] : '';
    $living_standard = isset($_POST["living_standard"]) ? $_POST["living_standard"] : '';
    $portfolio_expectation = isset($_POST["portfolio_expectation"]) ? $_POST["portfolio_expectation"] : '';
    $income_generation = isset($_POST["income_generation"]) ? $_POST["income_generation"] : '';
    $income_use = isset($_POST["income_use"]) ? $_POST["income_use"] : '';
    
    // Risk Tolerance
    $financial_situation = isset($_POST["financial_situation"]) ? $_POST["financial_situation"] : '';
    $investment_approach = isset($_POST["investment_approach"]) ? $_POST["investment_approach"] : '';
    $risk_reaction = isset($_POST["risk_reaction"]) ? $_POST["risk_reaction"] : '';
    $comfort_investment = isset($_POST["comfort_investment"]) ? $_POST["comfort_investment"] : '';
    $least_investment = isset($_POST["least_investment"]) ? $_POST["least_investment"] : '';
    $ideal_investment = isset($_POST["ideal_investment"]) ? $_POST["ideal_investment"] : '';
    $economy_optimism = isset($_POST["economy_optimism"]) ? $_POST["economy_optimism"] : '';
    $foreign_investment = isset($_POST["foreign_investment"]) ? $_POST["foreign_investment"] : '';
    
    // Validate required fields
    if (empty($name)) {
        $errors[] = "Name is required.";
    }
    
    if (empty($email)) {
        $errors[] = "Email is required.";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Invalid email format.";
    }
    
    if (empty($broker_info)) {
        $errors[] = "Broker's Name or CRD Number is required.";
    }
    
    // If no errors, proceed with email
    if (empty($errors)) {
        $to = "info@davidsonwealthteam.com";
        $subject = "New Saving and Investing Questionnaire Submission";
        
        // Build email content
        $email_content = "Saving and Investing Questionnaire Submission\n\n";
        $email_content .= "Personal Information:\n";
        $email_content .= "Name: $name\n";
        $email_content .= "Email: $email\n";
        $email_content .= "Address: $address\n";
        $email_content .= "City: $city\n";
        $email_content .= "Zip: $zip\n";
        $email_content .= "Phone: $phone\n";
        $email_content .= "Occupation: $occupation\n";
        $email_content .= "Broker's Name or CRD Number: $broker_info\n\n";
        
        $email_content .= "Financial Strength:\n";
        $email_content .= "Annual Income Range: $income\n";
        $email_content .= "Estimated Net Worth: $net_worth\n";
        $email_content .= "Source of Funds: $fund_source\n";
        $email_content .= "Initial Investment Amount: $initial_investment\n\n";
        
        $email_content .= "Time Horizon:\n";
        $email_content .= "Age Range: $age\n";
        $email_content .= "Primary Financial Goal: $primary_goal\n";
        $email_content .= "Time Frame for Goals: $time_frame\n";
        $email_content .= "Years Till Retirement: $retirement_years\n\n";
        
        $email_content .= "Financial Goals:\n";
        $email_content .= "Financial Goal Description: $financial_goal\n";
        $email_content .= "Living Standard Expectation: $living_standard\n";
        $email_content .= "Portfolio Expectation: $portfolio_expectation\n";
        $email_content .= "Income Generation Importance: $income_generation\n";
        $email_content .= "Income Use Plan: $income_use\n\n";
        
        $email_content .= "Risk Tolerance:\n";
        $email_content .= "Current Financial Situation: $financial_situation\n";
        $email_content .= "Investment Approach: $investment_approach\n";
        $email_content .= "Reaction to Portfolio Decline: $risk_reaction\n";
        $email_content .= "Most Comfortable Investment: $comfort_investment\n";
        $email_content .= "Least Preferred Investment: $least_investment\n";
        $email_content .= "Ideal Investment: $ideal_investment\n";
        $email_content .= "Economic Optimism: $economy_optimism\n";
        $email_content .= "Attitude to Foreign Investments: $foreign_investment\n";
        
        // Email headers
        $headers = "From: $name <$email>\r\n";
        $headers .= "Reply-To: $email\r\n";
        $headers .= "X-Mailer: PHP/" . phpversion();
        
        // Send email
        if (mail($to, $subject, $email_content, $headers)) {
            $success = true;
        } else {
            $errors[] = "Oops! Something went wrong and we couldn't send your message.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Form Submission Result</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #0066cc;
            margin-bottom: 20px;
        }
        .success {
            color: #28a745;
            font-weight: bold;
            margin-bottom: 20px;
        }
        .error {
            color: #dc3545;
            font-weight: bold;
            margin-bottom: 20px;
        }
        .error-list {
            background: #f8d7da;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .btn {
            display: inline-block;
            background: #0066cc;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
            margin-top: 20px;
        }
        .btn:hover {
            background: #0055aa;
        }
    </style>
</head>
<body>
    <div class="container">
        <?php if ($success): ?>
            <h1>Thank You!</h1>
            <p class="success">Your questionnaire has been successfully submitted. A representative will contact you shortly.</p>
            <a href="/" class="btn">Return to Home</a>
        <?php else: ?>
            <?php if (!empty($errors)): ?>
                <h1>Oops!</h1>
                <p class="error">There were some problems with your submission:</p>
                <div class="error-list">
                    <ul>
                        <?php foreach ($errors as $error): ?>
                            <li><?php echo $error; ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <p>Please go back and correct these errors.</p>
                <a href="javascript:history.back()" class="btn">Go Back</a>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</body>
</html>