<?php
session_start();

// 1. Check if user is logged in at all
if (!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
    header('Location: enter.html?error=not_logged_in');
    exit();
}

// 2. Verify this is the correct user (user1)
if ($_SESSION['user_id'] !== 'user1') {
    header('Location: unauthorized.php');
    exit();
}

// 3. Verify this is the correct page for this user
if ($_SESSION['allowed_page'] !== 'dashboard_user1.php') {
    header('Location: ' . $_SESSION['allowed_page']);
    exit();
}

// 4. Check session age (timeout after 30 minutes)
$inactive = 1800; // 30 minutes in seconds
if (isset($_SESSION['login_time']) && (time() - $_SESSION['login_time'] > $inactive)) {
    session_unset();
    session_destroy();
    header('Location: enter.html?error=session_expired');
    exit();
}
$_SESSION['login_time'] = time(); // Update last activity time

// 5. Regenerate session ID to prevent fixation
if (!isset($_SESSION['created'])) {
    $_SESSION['created'] = time();
} elseif (time() - $_SESSION['created'] > 1800) {
    session_regenerate_id(true);
    $_SESSION['created'] = time();
}

// 6. Add security headers
header("X-Frame-Options: DENY");
header("X-Content-Type-Options: nosniff");
header("X-XSS-Protection: 1; mode=block");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User 1 Dashboard</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f5f7fa;
        }
        .dashboard-container {
            max-width: 1000px;
            margin: 30px auto;
            padding: 30px;
            background: white;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        .welcome-header {
            color: #2c3e50;
            border-bottom: 2px solid #ecf0f1;
            padding-bottom: 15px;
            margin-bottom: 25px;
        }
        .user-stats {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
        }
        .logout-section {
            text-align: right;
            margin-top: 40px;
        }
        .logout-btn {
            background: #e74c3c;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: background 0.3s;
        }
        .logout-btn:hover {
            background: #c0392b;
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <h1 class="welcome-header">Welcome back, <?php echo htmlspecialchars($_SESSION['email'] ?? 'User'); ?>!</h1>
        
        <div class="user-stats">
            <div class="stat-card">
                <h3>Your Account</h3>
                <p>Email: <?php echo htmlspecialchars($_SESSION['email'] ?? 'N/A'); ?></p>
                <p>Last login: <?php echo date('Y-m-d H:i:s', $_SESSION['login_time'] ?? time()); ?></p>
            </div>
            
            <div class="stat-card">
                <h3>Security Status</h3>
                <p>Session active: <?php echo floor((time() - ($_SESSION['login_time'] ?? time())) / 60); ?> minutes</p>
                <p>IP Address: <?php echo htmlspecialchars($_SERVER['REMOTE_ADDR']); ?></p>
            </div>
            
            <div class="stat-card">
                <h3>Quick Actions</h3>
                <p><a href="profile.php">Update Profile</a></p>
                <p><a href="settings.php">Account Settings</a></p>
            </div>
        </div>
        
        <div class="user-content">
            <h2>Your Exclusive Dashboard</h2>
            <p>This content is protected and only accessible to you. Other users cannot view this page even if they try to access it directly.</p>
            
            <!-- Add your user-specific content here -->
            <div class="private-data">
                <h3>Confidential Information</h3>
                <p>This data is strictly for your eyes only.</p>
            </div>
        </div>
        
        <div class="logout-section">
            <form action="logout.php" method="post">
                <button type="submit" class="logout-btn">Logout</button>
            </form>
        </div>
    </div>
</body>
</html>