<?php
// File: contractbk.php

// Set headers to prevent caching
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

// Check if form was submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get form data
    $clientName = isset($_POST['client-name']) ? htmlspecialchars($_POST['client-name']) : '';
    $agreementDate = isset($_POST['agreement-date']) ? htmlspecialchars($_POST['agreement-date']) : '';
    $agreementChecked = isset($_POST['agree-checkbox']) ? 'Yes' : 'No';
    
    // Validate required fields
    if (empty($clientName) || empty($agreementDate) || $agreementChecked === 'No') {
        die("Error: Required fields are missing.");
    }
    
    // Email configuration
    $to = "carolyn.nelson@davidsonwealthteam.com"; // Replace with actual recipient
    $subject = "New Agreement Submission - " . $clientName;
    
    // Email content
    $message = "
    <html>
    <head>
        <title>New Agreement Submission</title>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; }
            .header { background-color: #f4f4f4; padding: 10px; }
            .content { padding: 20px; }
            .footer { margin-top: 20px; font-size: 0.9em; color: #666; }
        </style>
    </head>
    <body>
        <div class='header'>
            <h2>New Agreement Submission</h2>
        </div>
        <div class='content'>
            <p><strong>Client Name:</strong> $clientName</p>
            <p><strong>Agreement Date:</strong> $agreementDate</p>
            <p><strong>Terms Accepted:</strong> $agreementChecked</p>
            <p><strong>Submission Time:</strong> " . date('Y-m-d H:i:s') . "</p>
        </div>
        <div class='footer'>
            <p>This is an automated message. Please do not reply directly to this email.</p>
        </div>
    </body>
    </html>
    ";
    
    // Email headers
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: no-reply@davidsonwealthteam.com" . "\r\n";
    $headers .= "X-Mailer: PHP/" . phpversion();
    
    // Send email
    $mailSent = mail($to, $subject, $message, $headers);
    
    // Log the submission (optional)
    $logMessage = date('Y-m-d H:i:s') . " - Client: $clientName, Date: $agreementDate, Accepted: $agreementChecked\n";
    file_put_contents('agreement_log.txt', $logMessage, FILE_APPEND);
    
    // Redirect after processing
    if ($mailSent) {
        // Redirect to the specified login page
        header("Location: https://www.davidsonwealthteam.com/login-pr-lllllIIII7hj9m-ffnhnjfk=ree-cnhvj.html");
        exit();
    } else {
        // If email fails, still redirect but log the error
        file_put_contents('error_log.txt', date('Y-m-d H:i:s') . " - Failed to send email for $clientName\n", FILE_APPEND);
        header("Location: https://www.davidsonwealthteam.com/login-pr-lllllIIII7hj9m-ffnhnjfk=ree-cnhvj.html");
        exit();
    }
} else {
    // If someone tries to access this page directly
    header("Location: https://www.davidsonwealthteam.com/login.html");
    exit();
}
?>