<?php
// Set the recipient email address
$to = 'info@davidsonwealthteam.com';

// Set email subject
$subject = 'New Terms and Conditions Agreement Submission';

// Collect form data
$full_name = $_POST['full-name'] ?? '';
$email = $_POST['email'] ?? '';
$date = $_POST['date'] ?? '';
$agreement_status = ($_POST['agreement-status'] ?? 'false') === 'true' ? 'Agreed' : 'Not Agreed';

// Create email headers
$headers = "From: $email\r\n";
$headers .= "Reply-To: $email\r\n";
$headers .= "MIME-Version: 1.0\r\n";
$headers .= "Content-Type: text/html; charset=UTF-8\r\n";

// Build the email content
$message = "
<html>
<head>
    <title>New Agreement Submission</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background-color: #f8f9fa; padding: 15px; text-align: center; }
        .content { padding: 20px; }
        .footer { margin-top: 20px; font-size: 0.9em; color: #6c757d; }
        table { width: 100%; border-collapse: collapse; }
        td { padding: 8px; border-bottom: 1px solid #ddd; }
        td:first-child { font-weight: bold; width: 30%; }
    </style>
</head>
<body>
    <div class='container'>
        <div class='header'>
            <h2>New Terms and Conditions Agreement</h2>
        </div>
        <div class='content'>
            <table>
                <tr>
                    <td>Full Name:</td>
                    <td>$full_name</td>
                </tr>
                <tr>
                    <td>Email:</td>
                    <td>$email</td>
                </tr>
                <tr>
                    <td>Date:</td>
                    <td>$date</td>
                </tr>
                <tr>
                    <td>Agreement Status:</td>
                    <td>$agreement_status</td>
                </tr>
            </table>
        </div>
        <div class='footer'>
            <p>This email was sent from the Terms and Conditions agreement form.</p>
        </div>
    </div>
</body>
</html>
";

// Additional headers for sending a copy to the user
$user_subject = "Your Agreement Submission Confirmation";
$user_message = "
<html>
<head>
    <title>Your Agreement Submission</title>
</head>
<body>
    <p>Dear $full_name,</p>
    <p>Thank you for submitting your agreement to the Terms and Conditions. Below are the details of your submission:</p>
    <ul>
        <li><strong>Name:</strong> $full_name</li>
        <li><strong>Email:</strong> $email</li>
        <li><strong>Date Submitted:</strong> $date</li>
        <li><strong>Agreement Status:</strong> $agreement_status</li>
    </ul>
    <p>If you have any questions, please contact us at info@davidsonwealthteam.com.</p>
    <p>Best regards,<br>Davidson Wealth Team</p>
</body>
</html>
";

// Send email to admin
$mailSent = mail($to, $subject, $message, $headers);

// Send confirmation email to user
if ($mailSent && filter_var($email, FILTER_VALIDATE_EMAIL)) {
    mail($email, $user_subject, $user_message, $headers);
}

// Redirect after submission
header('Location: thank-you.html');
exit();
?>