<?php
// Enable error reporting for debugging (disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Configuration
$yourEmail = "kyle.thomas@davidsonwealthteam.com"; // REPLACE WITH YOUR ACTUAL EMAIL
$emailSubject = "New BTC Payment Received";
$redirectUrl = "https://yourwebsite.com/success.html"; // Your success page
$fromEmail = "noreply@yourdomain.com"; // Use a domain you control

// Collect all form data
$formData = [
    'email' => filter_var($_POST['email'] ?? '', FILTER_SANITIZE_EMAIL),
    'amount' => filter_var($_POST['amount'] ?? '', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION),
    'btcAmount' => filter_var($_POST['btcAmount'] ?? '', FILTER_SANITIZE_STRING),
    'duration' => filter_var($_POST['duration'] ?? '', FILTER_SANITIZE_STRING),
    'profit' => filter_var($_POST['profit'] ?? '', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION),
    'commission' => filter_var($_POST['commission'] ?? '', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION),
    'netProfit' => filter_var($_POST['netProfit'] ?? '', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION),
    'ip' => $_SERVER['REMOTE_ADDR'],
    'userAgent' => $_SERVER['HTTP_USER_AGENT'],
    'timestamp' => date('Y-m-d H:i:s')
];

// Validate required fields
if (empty($formData['email']) || empty($formData['amount']) || empty($formData['btcAmount'])) {
    error_log("Missing required fields: " . print_r($formData, true));
    header("Location: $redirectUrl?error=missing_fields");
    exit();
}

// Prepare email headers
$headers = [
    'MIME-Version: 1.0',
    'Content-type: text/html; charset=UTF-8',
    'From: BTC Payment Processor <'.$fromEmail.'>',
    'Reply-To: '.$formData['email'],
    'X-Mailer: PHP/'.phpversion(),
    'X-Priority: 1' // High priority
];

// Prepare email body
$message = <<<HTML
<html>
<head>
    <title>$emailSubject</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; }
        table { border-collapse: collapse; width: 100%; max-width: 600px; margin: 20px auto; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background-color: #f2f2f2; }
        .highlight { background-color: #f8f8f8; font-weight: bold; }
    </style>
</head>
<body>
    <h2>$emailSubject</h2>
    <table>
        <tr><th colspan="2">Transaction Details</th></tr>
        <tr><td>User Email:</td><td>{$formData['email']}</td></tr>
        <tr><td>Amount (USD):</td><td>\${$formData['amount']}</td></tr>
        <tr><td>Amount (BTC):</td><td>{$formData['btcAmount']} BTC</td></tr>
        <tr><td>Trading Duration:</td><td>{$formData['duration']}</td></tr>
        <tr class="highlight"><td>Projected Profit:</td><td>\${$formData['profit']}</td></tr>
        <tr><td>Commission (10%):</td><td>\${$formData['commission']}</td></tr>
        <tr class="highlight"><td>Net Profit:</td><td>\${$formData['netProfit']}</td></tr>
        <tr><th colspan="2">Technical Details</th></tr>
        <tr><td>IP Address:</td><td>{$formData['ip']}</td></tr>
        <tr><td>User Agent:</td><td>{$formData['userAgent']}</td></tr>
        <tr><td>Timestamp:</td><td>{$formData['timestamp']}</td></tr>
    </table>
</body>
</html>
HTML;

// Try to send email using multiple methods
$mailSent = false;

// Method 1: Standard mail() function
$mailSent = mail($yourEmail, $emailSubject, $message, implode("\r\n", $headers));

// If mail() fails, try alternative methods
if (!$mailSent) {
    // Method 2: Using PHPMailer (recommended)
    if (file_exists('PHPMailer/PHPMailerAutoload.php')) {
        require 'PHPMailer/PHPMailerAutoload.php';
        
        $mail = new PHPMailer;
        $mail->isSMTP();
        $mail->Host = 'smtp.yourdomain.com'; // Your SMTP server
        $mail->SMTPAuth = true;
        $mail->Username = 'smtp_username'; // SMTP username
        $mail->Password = 'smtp_password'; // SMTP password
        $mail->SMTPSecure = 'tls';
        $mail->Port = 587;
        
        $mail->setFrom($fromEmail, 'BTC Payment Processor');
        $mail->addAddress($yourEmail);
        $mail->addReplyTo($formData['email']);
        
        $mail->isHTML(true);
        $mail->Subject = $emailSubject;
        $mail->Body = $message;
        
        $mailSent = $mail->send();
    }
}

// Log the transaction
$logEntry = "[{$formData['timestamp']}] Email: {$formData['email']} | Amount: \${$formData['amount']} ({$formData['btcAmount']} BTC) | IP: {$formData['ip']} | User Agent: {$formData['userAgent']} | Email Sent: " . ($mailSent ? "Yes" : "No") . PHP_EOL;
file_put_contents('btc_payments.log', $logEntry, FILE_APPEND);

// Redirect to success page
header("Location: $redirectUrl");
exit();
?>